Imports System.ComponentModel
Imports System.Drawing
Imports System.WinForms


Public Class Form1
    Inherits System.WinForms.Form
    
    Private myMsgFilter As New TestMessageFilter()
    Dim sc As MySubClass
    
    Public Sub New()
        MyBase.New()
        Form1 = Me
        InitializeComponent()
        
        'ADD LATER
        'SUBCLASSING TECHNIQUE #3
        'System.WinForms.Application.AddMessageFilter(myMsgFilter)
        
        sc = New MySubClass()
    End Sub
    
    'Form overrides dispose to clean up the component list.
    Public Overrides Sub Dispose()
        MyBase.Dispose()
        components.Dispose()
    End Sub
    
#Region " Windows Form Designer generated code "
    
    'Required by the Windows Form Designer
    Private components As System.ComponentModel.Container
    Private WithEvents Button3 As System.WinForms.Button
    Private WithEvents TextBox1 As System.WinForms.TextBox
    Private WithEvents Button2 As System.WinForms.Button
    Private WithEvents Button1 As System.WinForms.Button
    
    Dim WithEvents Form1 As System.WinForms.Form
    
    'NOTE: The following procedure is required by the Windows Form Designer
    'It can be modified using the Windows Form Designer.  
    'Do not modify it using the code editor.
    Private Sub InitializeComponent()
        Me.components = New System.ComponentModel.Container()
        Me.Button1 = New System.WinForms.Button()
        Me.Button2 = New System.WinForms.Button()
        Me.Button3 = New System.WinForms.Button()
        Me.TextBox1 = New System.WinForms.TextBox()
        
        '@design Me.TrayHeight = 0
        '@design Me.TrayLargeIcon = False
        '@design Me.TrayAutoArrange = True
        Button1.Location = New System.Drawing.Point(8, 16)
        Button1.Size = New System.Drawing.Size(75, 23)
        Button1.TabIndex = 0
        Button1.Text = "Subclass"
        
        Button2.Location = New System.Drawing.Point(8, 48)
        Button2.Size = New System.Drawing.Size(75, 23)
        Button2.TabIndex = 1
        Button2.Text = "UnSubclass"
        
        Button3.Location = New System.Drawing.Point(8, 104)
        Button3.Size = New System.Drawing.Size(75, 23)
        Button3.TabIndex = 3
        Button3.Text = "Separate"
        
        TextBox1.Location = New System.Drawing.Point(88, 16)
        TextBox1.Multiline = True
        TextBox1.ScrollBars = System.WinForms.ScrollBars.Both
        TextBox1.WordWrap = False
        TextBox1.TabIndex = 2
        TextBox1.Size = New System.Drawing.Size(408, 336)
        Me.Text = "VB.NET Subclassing Example"
        Me.AutoScaleBaseSize = New System.Drawing.Size(5, 13)
        Me.ClientSize = New System.Drawing.Size(504, 357)
        
        Me.Controls.Add(Button3)
        Me.Controls.Add(TextBox1)
        Me.Controls.Add(Button2)
        Me.Controls.Add(Button1)
    End Sub
    
    'SUBCLASSING TECHNIQUE #1
    Protected Overrides Sub WndProc(ByRef m As Message)
        'Seems to work in tandem with subclassing technique #2
        If m.msg = microsoft.Win32.Interop.win.WM_RBUTTONDOWN Then
            textbox1.Text = textbox1.Text & m.msg.ToString() & chr(13) & chr(10)
        End If
        
        MyBase.WndProc(m)  'OR DefWndProc(m) SEEMS TO ALSO WORK
    End Sub
    
    Protected Overrides Function ProcessKeyPreview(ByRef m As Message) As Boolean
        textbox1.Text = textbox1.Text & "PROCESSKEYPREVIEW: msg = " & m.msg.ToString() & chr(13) & chr(10)
        ProcessKeyPreview = MyBase.ProcessKeyPreview(m)
    End Function
    
    Public Overrides Function PreProcessMessage(ByVal msg As Microsoft.Win32.Interop.MSG) As Boolean
        textbox1.Text = textbox1.Text & "PREPROCESSMESSAGE: msg = " & msg.message.ToString() & chr(13) & chr(10)
        PreProcessMessage = MyBase.PreProcessMessage(msg)
    End Function
    
    Protected Overrides Function IsInputChar(ByVal CharCode As Char) As Boolean
        textbox1.Text = textbox1.Text & "ISINPUTCHAR: CharCode = " & CharCode.ToString() & chr(13) & chr(10)
        IsInputChar = MyBase.IsInputChar(CharCode)
    End Function
    
    Protected Overrides Function IsInputKey(ByVal KeyData As Keys) As Boolean
        textbox1.Text = textbox1.Text & "ISINPUTKEY: KeyData = " & KeyData.ToString() & chr(13) & chr(10)
        textbox1.Text = textbox1.Text & "   KeyCode: " & KeyData.KeyCode.ToString() & chr(13) & chr(10)
        IsInputKey = MyBase.IsInputKey(Keydata)
    End Function
    
    Protected Overrides Function ProcessCmdKey(ByVal msg As Microsoft.Win32.Interop.MSG, ByVal KeyData As Keys) As Boolean
        textbox1.Text = textbox1.Text & "PROCESSCMDKEY: msg = " & msg.message.ToString() & chr(13) & chr(10)
        ProcessCmdKey = MyBase.ProcessCmdKey(msg, KeyData)
    End Function
    
    Protected Overrides Function ProcessDialogChar(ByVal CharCode As Char) As Boolean
        textbox1.Text = textbox1.Text & "PROCESSDIALOGCHAR: CharCode = " & CharCode.ToString() & chr(13) & chr(10)
        ProcessDialogChar = MyBase.ProcessDialogChar(CharCode)
    End Function
    
    Protected Overrides Function ProcessDialogKey(ByVal KeyData As Keys) As Boolean
        textbox1.Text = textbox1.Text & "PROCESSDIALOGKEY: KeyData = " & KeyData.ToString() & chr(13) & chr(10)
        textbox1.Text = textbox1.Text & "   KeyCode: " & KeyData.KeyCode.ToString() & chr(13) & chr(10)
        ProcessDialogKey = MyBase.ProcessDialogKey(KeyData)
    End Function
    
    Protected Overrides Function ProcessKeyEventArgs(ByRef m As Message) As Boolean
        textbox1.Text = textbox1.Text & "PROCESSKEYEVENTARGS: msg = " & m.msg.ToString() & chr(13) & chr(10)
        ProcessKeyEventArgs = MyBase.ProcessKeyEventArgs(m)
    End Function
    
    Protected Overrides Function ProcessMnemonic(ByVal CharCode As Char) As Boolean
        textbox1.Text = textbox1.Text & "PROCESSMNEMONIC: CharCode = " & CharCode.ToString() & chr(13) & chr(10)
        ProcessMnemonic = MyBase.ProcessMnemonic(CharCode)
    End Function
#End Region
    
    
    
    'SUBCLASS TECHNIQUE #2
    Protected Sub Button1_Click(ByVal sender As Object, ByVal e As System.EventArgs)
        'Don't try to assign handle more than once
        '   - throws a System.Exception error
        
        'NOTE: sc.Handle is the actual handle of the window (see Spy++)
        '      Also notice in Spy++ that the WndProc of the form-not the class-is modified
        '      both when the handle is assigned and unassigned
        
        'sc.Handle = 0
        'sc.FromHandle(sc.Handle) = null
        
        If sc.Handle() = 0 Then
            sc.AssignHandle(Me.Handle)
        Else
            msgbox("Don't try to subclass this window more than once")
        End If
        
        msgbox(Hex(sc.Handle)) ' = 787400
        'Dim x As NativeWindow = sc.FromHandle(sc.Handle)
        'x.Handle = 787400
        'x.ToString() = "VBSubclassing.Form1$MySubclass"
    End Sub
    
    Protected Sub Button2_Click(ByVal sender As Object, ByVal e As System.EventArgs)
        sc.ReleaseHandle()
        'The sc.Handle reverts back to 0
        
        'NOTE:
        'THIS DESTROYS THE WINDOW  --  sc.DestroyHandle()
        'ANY WINDOW WITHOUT A HANDLE IS SUBJECT TO GC
    End Sub
    
    Protected Sub Button3_Click(ByVal sender As Object, ByVal e As System.EventArgs)
        textbox1.Text = textbox1.Text & chr(13) & chr(10) & "------------------------------------" & chr(13) & chr(10) & chr(13) & chr(10)
    End Sub
    
    
    Public Class MySubclass
        Inherits NativeWindow
        
        Protected Overrides Sub WndProc(ByRef m As Message)
            If m.msg = microsoft.Win32.Interop.win.WM_RBUTTONDOWN Then
                msgbox(m.msg.ToString())
            End If
            
            MyBase.WndProc(m)
        End Sub
        
        Protected Overrides Sub OnHandleChange()
            'Trace.Listeners.Add(New TextWriterTraceListener(Console.Out))
            'Trace.Listeners.Add(New EventLogTraceListener())
            'Trace.Assert(True, "ASSERT", "ASSERT-DETAILS")
            'Trace.WriteLine("START")
            'PerformanceCounterManager.OutputDebugString(m.msg.ToString())
            'microsoft.Win32.Interop.Windows.OutputDebugString("START-INTEROP")
            'Trace.Flush()
            
            msgbox("Handle has changed")
        End Sub
    End Class
End Class



'SUBCLASSING TECHNIQUE #3 (CONTINUED)
Public Class TestMessageFilter
    'Implements System.WinForms.IMessageFilter
    'PROBLEM HERE
    
    Public Function PreFilterMessage(ByRef m As System.WinForms.Message) As Boolean
        If m.msg = Microsoft.Win32.Interop.win.WM_LBUTTONDOWN Then
            MessageBox.Show("Lbutton down")
        End If
    End Function
    
    Public Function PostFilterMessage(ByVal m As System.WinForms.Message) As Boolean
    End Function
End Class

